/////////////////////////////////////////////////////////////
// CINEMA SDK : FILTER        														 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_FILTERDATA_H
#define __C4D_FILTERDATA_H

#include "c4d_nodedata.h"

class Filename;
class String;
class BaseContainer;
class BaseDocument;
class BaseBitmap;
class PluginSceneLoader;
class PluginSceneSaver;

class BitmapLoaderData : public BaseData
{
	public:
		virtual Bool Identify(const Filename &name, UCHAR *probe, LONG size)=0;
		virtual LONG Load(const Filename &name, BaseBitmap *bm, LONG frame)=0;
		virtual LONG GetSaver(void);
};

class BitmapSaverData : public BaseData
{
	public:
		virtual LONG Save(const Filename &name, BaseBitmap *bm, BaseContainer *data, LONG savebits)=0;
		virtual Bool Edit(BaseContainer *data);
		virtual LONG GetMaxAlphas(BaseContainer *data);
};

#define SCENEFILTER_OBJECTS					(1<<0)
#define SCENEFILTER_MATERIALS				(1<<1)
#define SCENEFILTER_DIALOGSALLOWED	(1<<3)
#define SCENEFILTER_PROGRESSALLOWED	(1<<4)

class SceneLoaderData : public NodeData
{
	public:
		virtual Bool Identify(PluginSceneLoader *node, const Filename &name, UCHAR *probe, LONG size)=0;
		virtual LONG Load(PluginSceneLoader *node, const Filename &name, BaseDocument *doc, LONG filterflags, String *error, Bool *framescene)=0;

		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////
};

class SceneSaverData : public NodeData
{
	public:
		virtual LONG Save(PluginSceneSaver *node, const Filename &name, BaseDocument *doc, LONG filterflags)=0;

		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////
};

Bool RegisterBitmapLoaderPlugin(LONG id, const String &str, LONG info, BitmapLoaderData *dat);
Bool RegisterBitmapSaverPlugin(LONG id, const String &str, LONG info, BitmapSaverData *dat, const String &suffix);
Bool RegisterSceneLoaderPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, void *emulation=NULL);
Bool RegisterSceneSaverPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, const String &suffix, void *emulation=NULL);

#endif
